from axelrod.action import Action

from axelrod.player import Player

C, D = Action.C, Action.D

class WorseAndWorse(Player):
    """
    Defects with probability of 'current turn / 1000'. Therefore
    it is more and more likely to defect as the round goes on.

    Source code available at the download tab of [Prison1998]_


    Names:
        - Worse and Worse: [Prison1998]_
    """

    name = "Worse and Worse"
    classifier = {
        "memory_depth": float("inf"),
        "stochastic": True,
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    def strategy(self, opponent: Player) -> Action:
        """Actual strategy definition that determines player's action."""
        current_round = len(self.history) + 1
        probability = 1 - current_round / 1000
        return self._random.random_choice(probability)